
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

-- the total number of all slices is 2^u
-- let max_big_slice equal to b, then b*v is the minizal common multiple of (u+v) and v
--LAST_BIG_SLICE_AND_SLICE is (MAX_BIG_SLICE-1)*2^u - 1, which is {BIG_SLICE_LAST,SLICE_ZERO}
--(MAX_BIG_SLICE-1), LAST_BIG_SLICE is the last big slice we want, equal to (b-1)
-- The last slice


LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;

ENTITY ctrl IS
   PORT (
      mclk                    : IN std_logic;
      rst                     : IN std_logic;
      valid                   : IN std_logic;
      symbol0                 : IN std_logic_vector(3 - 1 DOWNTO 0);
      symbol1                 : IN std_logic_vector(3 - 1 DOWNTO 0);
      pattern                 : IN std_logic_vector(2 - 1 DOWNTO 0);
      valid_slice             : OUT std_logic;
      slice                   : OUT std_logic;
      shift_cnt               : OUT std_logic;
      adr0_shift              : OUT std_logic;
      adr1_shift              : OUT std_logic;
      reg_symbol0             : OUT std_logic_vector(3 - 1 DOWNTO 0);
      reg_symbol1             : OUT std_logic_vector(3 - 1 DOWNTO 0);
      reg_pattern             : OUT std_logic_vector(2 - 1 DOWNTO 0);
      valid_decs              : OUT std_logic);
END ctrl;

ARCHITECTURE translated OF ctrl IS

   COMPONENT delayT
      GENERIC (
          Data_Width                     :  integer := 12;
          Delay_Count                    :  integer := 1);
      PORT (
         mclk                    : IN  std_logic;
         rst                     : IN  std_logic;
         in_vhcg1                : IN  std_logic_vector(Data_Width - 1 DOWNTO 0);
         out_vhcg2               : OUT std_logic_vector(Data_Width - 1 DOWNTO 0));
   END COMPONENT;


   SIGNAL big_slice                :  std_logic;
   SIGNAL next_slice               :  std_logic;
   SIGNAL next_shift_cnt           :  std_logic;
   SIGNAL next_big_slice           :  std_logic;
   SIGNAL tmp_next_big_slice       :  std_logic;
   SIGNAL wire_adr0                :  std_logic_vector(1 + 1 - 1 DOWNTO 0);
   SIGNAL wire_adr1                :  std_logic_vector(1 + 1 - 1 DOWNTO 0);
   SIGNAL adr0                     :  std_logic;
   SIGNAL adr1                     :  std_logic;
   SIGNAL next_adr0_shift          :  std_logic;
   SIGNAL next_adr1_shift          :  std_logic;
   SIGNAL vhcg_13                  :  std_logic_vector(8 DOWNTO 0);
   SIGNAL vhcg_15                  :  std_logic_vector(8 DOWNTO 0);
   SIGNAL slice_vhcg1              :  std_logic;
   SIGNAL shift_cnt_vhcg2          :  std_logic;
   SIGNAL adr0_shift_vhcg3         :  std_logic;
   SIGNAL adr1_shift_vhcg4         :  std_logic;
   --SIGNAL reg_symbol0_vhcg5        :  std_logic_vector(3 - 1 DOWNTO 0);
   --SIGNAL reg_symbol1_vhcg6        :  std_logic_vector(3 - 1 DOWNTO 0);
   --SIGNAL reg_pattern_vhcg7        :  std_logic_vector(2 - 1 DOWNTO 0);
   SIGNAL valid_slice_vhcg8        :  std_logic;
   --SIGNAL valid_decs_vhcg9         :  std_logic;

BEGIN
   slice <= slice_vhcg1;
   shift_cnt <= shift_cnt_vhcg2;
   adr0_shift <= adr0_shift_vhcg3;
   adr1_shift <= adr1_shift_vhcg4;

   valid_slice <= valid_slice_vhcg8;

   wire_adr0 <= next_slice & '0' ;
   wire_adr1 <= next_slice & '1' ;
   vhcg_13 <= symbol0 & symbol1 & pattern & valid_slice_vhcg8;
   --(reg_symbol0_vhcg5 , reg_symbol1_vhcg6 , reg_pattern_vhcg7 , valid_decs_vhcg9) <= vhcg_15 ;
   reg_symbol0 <= vhcg_15(8 downto 6);
   reg_symbol1 <= vhcg_15(5 downto 3);
   reg_pattern <= vhcg_15(2 downto 1);
   valid_decs <= vhcg_15(0);
   delayT_symbols : delayT
      GENERIC MAP (
         Data_Width => 3 * 2 + 2 + 1,
         Delay_Count => 1)
      PORT MAP (
         mclk => mclk,
         rst => rst,
         in_vhcg1 => vhcg_13,
         out_vhcg2 => vhcg_15);


   PROCESS (mclk, rst)
   BEGIN
      IF (rst = '1') THEN
        -- (big_slice, slice_vhcg1) <= '1' & '1';
         big_slice <= '1';
         slice_vhcg1  <= '1';
         valid_slice_vhcg8 <= '0';
         shift_cnt_vhcg2 <= '0';
         adr0_shift_vhcg3 <= '0';
         adr1_shift_vhcg4 <= '0';
      ELSIF (mclk'EVENT AND mclk = '1') THEN
         IF (slice_vhcg1 = '1') THEN
            IF (valid = '1') THEN
               slice_vhcg1 <= next_slice;
               big_slice <= next_big_slice;
               valid_slice_vhcg8 <= '1';
               shift_cnt_vhcg2 <= next_shift_cnt;
               adr0_shift_vhcg3 <= next_adr0_shift;
               adr1_shift_vhcg4 <= next_adr1_shift;
            ELSE
               valid_slice_vhcg8 <= '0';
            END IF;
         ELSE
            slice_vhcg1 <= next_slice;
            big_slice <= next_big_slice;
            shift_cnt_vhcg2 <= next_shift_cnt;
            adr0_shift_vhcg3 <= next_adr0_shift;
            adr1_shift_vhcg4 <= next_adr1_shift;
         END IF;
      END IF;
   END PROCESS;
   (tmp_next_big_slice, next_slice) <= big_slice & slice_vhcg1 + '1' ;

   PROCESS (tmp_next_big_slice, big_slice, slice_vhcg1)
      VARIABLE next_big_slice_vhcg16  : std_logic;
   BEGIN
      IF (big_slice & slice_vhcg1 = '1' & '1') THEN
         next_big_slice_vhcg16 := '0';
      ELSE
         next_big_slice_vhcg16 := tmp_next_big_slice;
      END IF;
      next_big_slice <= next_big_slice_vhcg16;
   END PROCESS;
   next_shift_cnt <= next_slice ;

   PROCESS (next_big_slice, wire_adr0, wire_adr1)
      VARIABLE adr0_vhcg17  : std_logic;
      VARIABLE adr1_vhcg18  : std_logic;
   BEGIN
      CASE next_big_slice IS
         WHEN '0' =>
                  adr0_vhcg17 := wire_adr0(1);
                  adr1_vhcg18 := wire_adr1(1);
         WHEN OTHERS  =>
                  adr0_vhcg17 := wire_adr0(0);
                  adr1_vhcg18 := wire_adr1(0);

      END CASE;
      adr0 <= adr0_vhcg17;
      adr1 <= adr1_vhcg18;
   END PROCESS;

   PROCESS (next_shift_cnt, adr0, adr1)
      VARIABLE next_adr0_shift_vhcg19  : std_logic;
      VARIABLE next_adr1_shift_vhcg20  : std_logic;
   BEGIN
      CASE next_shift_cnt IS
         WHEN '0' =>
                  next_adr0_shift_vhcg19 := adr0;
                  next_adr1_shift_vhcg20 := adr1;
         WHEN OTHERS  =>
                  next_adr0_shift_vhcg19 := adr1;
                  next_adr1_shift_vhcg20 := adr0;

      END CASE;
      next_adr0_shift <= next_adr0_shift_vhcg19;
      next_adr1_shift <= next_adr1_shift_vhcg20;
   END PROCESS;

END translated;
