
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;
Use work.vhcg_pkg.all;
ENTITY pe IS
   GENERIC (
      PE_ID                          :  integer := 0);
   PORT (
      mclk                    : IN std_logic;
      rst                     : IN std_logic;
      valid                   : IN std_logic;
      slice                   : IN std_logic;
      shift_cnt               : IN std_logic;
      adr0_shift              : IN std_logic;
      adr1_shift              : IN std_logic;
      symbol0                 : IN std_logic_vector(3 - 1 DOWNTO 0);
      symbol1                 : IN std_logic_vector(3 - 1 DOWNTO 0);
      pattern                 : IN std_logic_vector(2 - 1 DOWNTO 0);
      in_sm0                  : IN std_logic_vector(8 - 1 DOWNTO 0);
      in_sm1                  : IN std_logic_vector(8 - 1 DOWNTO 0);
      out_sm0                 : OUT std_logic_vector(8 - 1 DOWNTO 0);
      out_sm1                 : OUT std_logic_vector(8 - 1 DOWNTO 0);
      dec0                    : OUT std_logic;
      dec1                    : OUT std_logic);
END pe;

ARCHITECTURE translated OF pe IS

   COMPONENT butfly2
      GENERIC (
          Bit_Width                      :  integer := 3;
          SM_Width                       :  integer := 8;
          BM_Width                       :  integer := 4);
      PORT (
         old_sm0                 : IN  std_logic_vector(SM_Width - 1 DOWNTO 0);
         old_sm1                 : IN  std_logic_vector(SM_Width - 1 DOWNTO 0);
         state_cluster           : IN  std_logic_vector(6 - 2 DOWNTO 0);
         symbol0                 : IN  std_logic_vector(Bit_Width - 1 DOWNTO 0);
         symbol1                 : IN  std_logic_vector(Bit_Width - 1 DOWNTO 0);
         pattern                 : IN  std_logic_vector(2 - 1 DOWNTO 0);
         new_sm0                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
         new_sm1                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
         dec0                    : OUT std_logic;
         dec1                    : OUT std_logic);
   END COMPONENT;

   COMPONENT smu
      PORT (
         mclk                    : IN  std_logic;
         rst                     : IN  std_logic;
         valid                   : IN  std_logic;
         shift_cnt               : IN  std_logic;
         adr0_shift              : IN  std_logic;
         adr1_shift              : IN  std_logic;
         wr_sm0                  : IN  std_logic_vector(8 - 1 DOWNTO 0);
         wr_sm1                  : IN  std_logic_vector(8 - 1 DOWNTO 0);
         rd_sm0                  : OUT std_logic_vector(8 - 1 DOWNTO 0);
         rd_sm1                  : OUT std_logic_vector(8 - 1 DOWNTO 0));
   END COMPONENT;


   SIGNAL pe_id_vhcg5              :  std_logic_vector(4 - 1 DOWNTO 0);
   SIGNAL wire_dec0                :  std_logic;
   SIGNAL wire_dec1                :  std_logic;
   SIGNAL wr_sm0                   :  std_logic_vector(8 - 1 DOWNTO 0);
   SIGNAL wr_sm1                   :  std_logic_vector(8 - 1 DOWNTO 0);
   SIGNAL vhcg_6                   :  std_logic_vector(4 DOWNTO 0);
   SIGNAL out_sm0_vhcg1            :  std_logic_vector(8 - 1 DOWNTO 0);
   SIGNAL out_sm1_vhcg2            :  std_logic_vector(8 - 1 DOWNTO 0);
   SIGNAL dec0_vhcg3               :  std_logic;
   SIGNAL dec1_vhcg4               :  std_logic;

BEGIN
   out_sm0 <= out_sm0_vhcg1;
   out_sm1 <= out_sm1_vhcg2;
   dec0 <= dec0_vhcg3;
   dec1 <= dec1_vhcg4;
   pe_id_vhcg5 <= CONV_STD_LOGIC_VECTOR(PE_ID, 4) ;
   vhcg_6 <= slice & pe_id_vhcg5;
   butfly2_0 : butfly2
      PORT MAP (
         old_sm0 => in_sm0,
         old_sm1 => in_sm1,
         state_cluster => vhcg_6,
         symbol0 => symbol0,
         symbol1 => symbol1,
         pattern => pattern,
         new_sm0 => wr_sm0,
         new_sm1 => wr_sm1,
         dec0 => wire_dec0,
         dec1 => wire_dec1);

   smu_i : smu
      PORT MAP (
         mclk => mclk,
         rst => rst,
         valid => valid,
         shift_cnt => shift_cnt,
         adr0_shift => adr0_shift,
         adr1_shift => adr1_shift,
         wr_sm0 => wr_sm0,
         wr_sm1 => wr_sm1,
         rd_sm0 => out_sm0_vhcg1,
         rd_sm1 => out_sm1_vhcg2);


   PROCESS (mclk, rst)
   BEGIN
      IF (rst = '1') THEN
         dec0_vhcg3 <= '0';
         dec1_vhcg4 <= '0';
      ELSIF (mclk'EVENT AND mclk = '1') THEN
         IF (valid = '1') THEN
            dec0_vhcg3 <= wire_dec0;
            dec1_vhcg4 <= wire_dec1;
         END IF;
      END IF;
   END PROCESS;

END translated;
