
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;
Use work.vhcg_pkg.all;
ENTITY sync_mem IS
   GENERIC (
      -- sync_mem is not
      -- the output data of the async_mem should be unregistered
      -- Hits:
      DATA_WIDTH                     :  integer := 32;
      ADDRESS_WIDTH                  :  integer := 10);
   PORT (
      clk                     : IN std_logic;
      wr_data                 : IN std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);
      wr_adr                  : IN std_logic_vector(ADDRESS_WIDTH - 1 DOWNTO 0);
      wr_en                   : IN std_logic;
      rd_adr                  : IN std_logic_vector(ADDRESS_WIDTH - 1 DOWNTO 0);
      rd_en                   : IN std_logic;
      rd_data                 : OUT std_logic_vector(DATA_WIDTH - 1 DOWNTO 0));
END sync_mem;

ARCHITECTURE translated OF sync_mem IS

   TYPE vhcg_2 IS ARRAY (1023 DOWNTO 0) OF std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);

   SIGNAL mem                      :  vhcg_2;
   SIGNAL rd_data_vhcg1            :  std_logic_vector(DATA_WIDTH - 1 DOWNTO 0);

BEGIN
   rd_data <= rd_data_vhcg1;

   PROCESS (clk)
   BEGIN
      IF (clk'EVENT AND clk = '1') THEN
         IF (rd_en = '1') THEN
            rd_data_vhcg1 <= mem(to_integer(rd_adr));
         ELSE
            rd_data_vhcg1 <= (OTHERS => 'X');
         END IF;
         IF (wr_en = '1') THEN
            mem(to_integer(wr_adr)) <= wr_data;
         END IF;
      END IF;
   END PROCESS;

END translated;
