--///////////////////////////////////////////////////////////////////
--///////////////////////////////////////////////////////////////////
--         //////                                    //////
--///////////////////////////////////////////////////////////////////
--///                                                             ///
--/// This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/// which is written by Mike Johnson at OpenCores.org  and      ///
--/// distributed under GPL license.                              ///
--///                                                             ///
--/// If you have any advice,                                     ///
--/// please email to jhonson.zhu@gmail.com                       ///
--///                                                             ///
--///////////////////////////////////////////////////////////////////
--
--///////////////////////////////////////////////////////////////////
--

-- package VHCG;

LIBRARY ieee;
USE ieee.std_logic_1164.all;

PACKAGE VHCG_PKG IS
   FUNCTION xor_br (
      val : std_logic_vector) RETURN std_logic;
    
   FUNCTION conv_std_logic_vector (
      val      : IN integer;
      len      : IN integer) RETURN std_logic_vector;
   
   FUNCTION conv_std_logic_vector (
      val      : IN std_logic;
      len      : IN integer) RETURN std_logic_vector;
         
   FUNCTION conv_std_logic (
      val      : IN boolean) RETURN std_logic;   

   FUNCTION to_integer (
      val      : std_logic_vector) RETURN integer;
   
   FUNCTION to_integer (
      val      : std_logic) RETURN integer;
      
end;

package body VHCG_PKG is
   FUNCTION xor_br (
      val : std_logic_vector) RETURN std_logic IS

      VARIABLE rtn : std_logic := '0';
   BEGIN
      FOR index IN val'RANGE LOOP
         rtn := rtn XOR val(index);
      END LOOP;
      RETURN(rtn);
   END xor_br;
   --
   
   FUNCTION conv_std_logic (
      val      : IN boolean) RETURN std_logic IS
   BEGIN
      IF (val) THEN
         RETURN('1');
      ELSE
         RETURN('0');
      END IF;
   END conv_std_logic;

   FUNCTION conv_std_logic (
      val      : IN integer) RETURN std_logic IS
   BEGIN
      IF (val = 1) THEN
         RETURN('1');
      ELSE
         RETURN('0');
      END IF;
   END conv_std_logic;
   --
   FUNCTION conv_std_logic_vector (
      val      : IN integer;
      len      : IN integer) RETURN std_logic_vector IS
      
      VARIABLE rtn      : std_logic_vector(len-1 DOWNTO 0) := (OTHERS => '0');
      VARIABLE num  : integer := val;
      VARIABLE r       : integer;
   BEGIN
      FOR index IN 0 TO len-1 LOOP
         r := num rem 2;
         num := num/2;
         IF (r = 1) THEN
            rtn(index) := '1';
         ELSE
            rtn(index) := '0';
         END IF;
      END LOOP;
      RETURN(rtn);
   END conv_std_logic_vector;
   
   FUNCTION conv_std_logic_vector (
      val      : IN std_logic;
      len      : IN integer) RETURN std_logic_vector IS
      
      VARIABLE rtn      : std_logic_vector(len-1 DOWNTO 0) := (OTHERS => '0');
   BEGIN
      rtn(0) := val;
      RETURN(rtn);
   END conv_std_logic_vector;
   --
   FUNCTION to_integer (
      val      : std_logic_vector) RETURN integer IS

      CONSTANT vec      : std_logic_vector(val'high-val'low DOWNTO 0) := val;      
      VARIABLE rtn      : integer := 0;
   BEGIN
      FOR index IN vec'RANGE LOOP
         IF (vec(index) = '1') THEN
            rtn := rtn + (2**index);
         END IF;
      END LOOP;
      RETURN(rtn);
   END to_integer;      
   
   --
  FUNCTION to_integer (
      val      : std_logic) RETURN integer IS

      CONSTANT vec      : std_logic := val;      
      VARIABLE rtn      : integer := 0;
   BEGIN
         IF (vec = '1') THEN
            rtn := 1;
         END IF;
      RETURN(rtn);
   END to_integer;                  
   --
end;
