
-- Thanks for XHDL
--///////////////////////////////////////////////////////////////////
--///////////////////////////////////////////////////////////////////
--         //////                                    //////
--///////////////////////////////////////////////////////////////////
--///                                                             ///
--/// This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/// which is written by Mike Johnson at OpenCores.org  and      ///
--/// distributed under GPL license.                              ///
--///                                                             ///
--/// If you have any advice,                                     ///
--/// please email to jhonson.zhu@gmail.com                       ///
--///                                                             ///
--///////////////////////////////////////////////////////////////////
--
--///////////////////////////////////////////////////////////////////
--   For K=9, rate=1/2, code=(431 , 285)
--

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;
use ieee.std_logic_textio.all;

use work.vhcg_pkg.all;
LIBRARY std;
use std.textio.all;

ENTITY test_random_data IS
 END test_random_data;

ARCHITECTURE compbody OF test_random_data IS

    component encoder IS
        PORT (
            clock                   : IN std_logic;
            reset                   : IN std_logic;
            srst                    : IN std_logic;
            bit_in                  : IN std_logic;
            valid_in                : IN std_logic;
            symbol0                 : OUT std_logic;
            symbol1                 : OUT std_logic;
            valid_out               : OUT std_logic);
    end component;

    component decoder IS
        PORT (
            mclk                    : IN std_logic;
            rst                     : IN std_logic;
            srst                    : IN std_logic;
            valid_in                : IN std_logic;
            symbol0                 : IN std_logic_vector(3 - 1 DOWNTO 0);
            symbol1                 : IN std_logic_vector(3 - 1 DOWNTO 0);
            pattern                 : IN std_logic_vector(2 - 1 DOWNTO 0);
            bit_out                 : OUT std_logic;
            valid_out               : OUT std_logic);
    end component;

    CONSTANT vhcg_timescale         : time := 1 ns;


    SIGNAL clock                    :  std_logic := '1';
    SIGNAL reset                    :  std_logic := '1';
    SIGNAL srst                     :  std_logic := '0';
    SIGNAL enc_bit_in               :  std_logic := '0';
    SIGNAL enc_valid_in             :  std_logic := '0';
    SIGNAL enc_symbol0              :  std_logic;
    SIGNAL enc_symbol1              :  std_logic;
    SIGNAL enc_valid_out            :  std_logic;
    SIGNAL dec_symbol0              :  std_logic_vector(3 - 1 DOWNTO 0) := "000";
    SIGNAL dec_symbol1              :  std_logic_vector(3 - 1 DOWNTO 0) := "000";
    SIGNAL dec_valid_in             :  std_logic := '0';
    SIGNAL pattern                  :  std_logic_vector(2 - 1 DOWNTO 0) := "11";
    SIGNAL dec_bit_out              :  std_logic;
    SIGNAL dec_valid_out            :  std_logic;
    SIGNAL enc_in_buf               :  std_logic_vector(2 * 64 - 1 DOWNTO 0);
    SIGNAL dec_out_error            :  std_logic := '0';
    SIGNAL glb_seed                 :  std_logic_vector(31 DOWNTO 0) := "00000000000011100100000000000000";
    FILE f_enc_in                 : TEXT open write_mode IS "enc_in.txt";
    FILE f_enc_out                : TEXT open write_mode IS "enc_out.txt";
    FILE f_dec_out                : TEXT open write_mode IS "dec_out.txt";
    signal ccnt                     :  integer := 0;
    signal count                    :  integer := 0;
    signal buf_in_cnt               :  integer := 0;
    signal buf_out_cnt              :  integer := 0;
    signal total_count              :  integer := 0;
    signal sim_done                 :  std_logic := '0';

BEGIN

    clock_gen: process
    begin
       wait for 1 * vhcg_timescale; IF (sim_done='1') THEN wait; else clock <= not clock; END IF;
    end process clock_gen;

    simulus_gen: PROCESS
    BEGIN
            wait for 10 ns;
            reset <= '1';
            WAIT FOR 100.5 * vhcg_timescale;
            reset <= '0';
            WAIT;
    END PROCESS simulus_gen;

    PROCESS
    BEGIN
        WAIT UNTIL (clock'EVENT AND clock = '1') OR (reset'EVENT AND reset = '1');
        IF (reset = '1') THEN
            enc_bit_in <= '0';
            enc_valid_in <= '0';
            ccnt <= 0;
            count <= 0;
        ELSE
            IF (ccnt = 1) THEN
                enc_valid_in <= '1';
                enc_bit_in <= xor_br(glb_seed);
                glb_seed <= glb_seed + "00000000000000000000000000000001";
                count <= count + 1;
                ccnt <= 0;
            ELSE
                enc_valid_in <= '0';
                ccnt <= ccnt + 1;
            END IF;
            IF (count = 10000) THEN
                sim_done<='1';
                REPORT "Simulation done. Success!";
                wait;
            END IF;

        END IF;
    END PROCESS;

    enc : encoder
        PORT MAP (
            clock => clock,
            reset => reset,
            srst => srst,
            bit_in => enc_bit_in,
            valid_in => enc_valid_in,
            symbol0 => enc_symbol0,
            symbol1 => enc_symbol1,
            valid_out => enc_valid_out);


    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (clock'EVENT AND clock = '1');
        IF (reset = '1') THEN
            dec_valid_in <= '0';
            dec_symbol0 <= (others => '0');
            dec_symbol0 <= "000";
            dec_symbol1 <= (others => '0');
            dec_symbol1 <= "000";
        ELSE
            IF (enc_valid_out = '1') THEN
                dec_valid_in <= '1';
                IF (enc_symbol0 = '1') THEN
                    dec_symbol0 <= "111";
                ELSE
                    dec_symbol0 <= "000";
                END IF;
                IF (enc_symbol1 = '1') THEN
                    dec_symbol1 <= "111";
                ELSE
                    dec_symbol1 <= "000";
                END IF;
            ELSE
                dec_valid_in <= '0';
            END IF;
        END IF;
    END PROCESS;

    dec : decoder
        PORT MAP (
            mclk => clock,
            rst => reset,
            srst => srst,
            valid_in => dec_valid_in,
            symbol0 => dec_symbol0,
            symbol1 => dec_symbol1,
            pattern => pattern,
            bit_out => dec_bit_out,
            valid_out => dec_valid_out);

    pattern <= "11" ;

    PROCESS
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (clock'EVENT AND clock = '1');
        IF (reset = '1') THEN
            buf_in_cnt <= 0;
        ELSE
            IF (enc_valid_in = '1') THEN
                enc_in_buf(buf_in_cnt) <= enc_bit_in;
                IF ((buf_in_cnt + 1) = buf_out_cnt) THEN
                    FOR X IN 1 TO 5 LOOP
                        WAIT UNTIL (clock'EVENT AND clock = '1');

                    END LOOP;
                    ASSERT (FALSE) REPORT "Error: data buffer overflow probably due to decoder latency." SEVERITY FAILURE;
                ELSE
                    IF (buf_in_cnt = 2 * 64 - 1) THEN
                        buf_in_cnt <= 0;
                    ELSE
                        buf_in_cnt <= buf_in_cnt + 1;
                    END IF;
                END IF;
            END IF;
        END IF;
    END PROCESS;

    PROCESS
    variable    myline : line;
    BEGIN
        WAIT UNTIL (reset'EVENT AND reset = '1') OR (clock'EVENT AND clock = '1');
        IF (reset = '1') THEN
            buf_out_cnt <= 0;
            total_count <= 0;
            dec_out_error <= '0';
        ELSE
            IF (dec_valid_out = '1') THEN
                IF (dec_bit_out /= enc_in_buf(buf_out_cnt)) THEN
                    dec_out_error <= '1';
                    FOR X IN 1 TO 5 LOOP
                        WAIT UNTIL (clock'EVENT AND clock = '1');

                    END LOOP;
                    ASSERT (FALSE) REPORT "Error: decoder output failure." SEVERITY FAILURE;
                END IF;
                IF (buf_out_cnt = 2 * 64 - 1) THEN
                    buf_out_cnt <= 0;
                    write(myline, string'("Info: decoder output correct at bit index "));
                    --hwrite(myline, conv_std_logic_vector(total_count,32));
                    write(myline, integer'image(total_count));
                    writeline(output, myline);
                ELSE
                    buf_out_cnt <= buf_out_cnt + 1;
                END IF;
                total_count <= total_count + 1;
            END IF;
        END IF;
    END PROCESS;

    PROCESS
        VARIABLE vhcg_initial : BOOLEAN := TRUE;
    BEGIN
        IF (vhcg_initial) THEN

            vhcg_initial := FALSE;
        ELSE
            WAIT;
        END IF;
    END PROCESS;

    PROCESS
    variable myline : line;
    BEGIN
        WAIT UNTIL (clock'EVENT AND clock = '1');
        IF (enc_valid_in = '1') THEN
            hwrite(myline, conv_std_logic_vector(enc_bit_in,4));
            WRITEline(f_enc_in, myline);
        END IF;
    END PROCESS;

    PROCESS
        VARIABLE vhcg_initial : BOOLEAN := TRUE;
    BEGIN
        IF (vhcg_initial) THEN

            vhcg_initial := FALSE;
        ELSE
            WAIT;
        END IF;
    END PROCESS;

    PROCESS
    variable myline : line;
    variable symbol : std_logic_vector(3 downto 0);
    BEGIN
        WAIT UNTIL (clock'EVENT AND clock = '1');
        IF (enc_valid_out = '1') THEN
            symbol := ("00" & enc_symbol0 & enc_symbol1);
            hwrite(myline, symbol );
            writeline(f_enc_out, myline);
        END IF;
    END PROCESS;

    PROCESS
        VARIABLE vhcg_initial : BOOLEAN := TRUE;
    BEGIN
        IF (vhcg_initial) THEN

            vhcg_initial := FALSE;
        ELSE
            WAIT;
        END IF;
    END PROCESS;

    PROCESS
    variable myline : line;
    BEGIN
        WAIT UNTIL (clock'EVENT AND clock = '1');
        IF (dec_valid_out = '1') THEN
            hwrite(myline, conv_std_logic_vector(dec_bit_out,4) );
            WRITEline(f_dec_out, myline);
        END IF;
    END PROCESS;

END compbody;
