
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

-- the number of stages of one traceback output. It should be pow of two. The stage
-- is the stage of encode lattice of radix r.
-- 2^OUT_STAGE_RADIX

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;
Use work.vhcg_pkg.all;
ENTITY filo IS
   PORT (
      clk                     : IN std_logic;
      rst                     : IN std_logic;
      en_filo_in              : IN std_logic;
      filo_in                 : IN std_logic;
      en_filo_out             : IN std_logic;
      filo_out                : OUT std_logic;
      valid_out               : OUT std_logic);
END filo;

ARCHITECTURE translated OF filo IS

   TYPE vhcg_3 IS ARRAY (32 - 1 DOWNTO 0) OF std_logic;

   SIGNAL regfile                  :  vhcg_3;
   SIGNAL index                    :  std_logic_vector(5 - 1 DOWNTO 0);
   SIGNAL index_bit                :  std_logic;
   SIGNAL push_or_pop              :  std_logic;
   SIGNAL regbyte                  :  std_logic;
   SIGNAL inc_index                :  std_logic_vector(5 - 1 DOWNTO 0);
   SIGNAL dec_index                :  std_logic_vector(5 - 1 DOWNTO 0);
   SIGNAL i                        :  integer;
   SIGNAL filo_out_vhcg1           :  std_logic;
   SIGNAL valid_out_vhcg2          :  std_logic;

BEGIN
   filo_out <= filo_out_vhcg1;
   valid_out <= valid_out_vhcg2;
   inc_index <= index + "00001" ;
   dec_index <= index - "00001" ;
   regbyte <= regfile(to_integer(index)) ;

   PROCESS (clk, rst)
   BEGIN
      IF (rst = '1') THEN
         FOR i IN 0 TO (32 - 1) LOOP
            regfile(i) <= '0';
         END LOOP;
         filo_out_vhcg1 <= '0';
         index <= "00000";
         index_bit <= '1';
         valid_out_vhcg2 <= '0';
         push_or_pop <= '0';
      ELSIF (clk'EVENT AND clk = '1') THEN
         valid_out_vhcg2 <= push_or_pop;
         IF (push_or_pop = '0') THEN
            IF (en_filo_in = '1') THEN
               regfile(to_integer(index)) <= filo_in;
               IF (inc_index = "00000") THEN
                  index <= "11111";
                  push_or_pop <= '1';
               ELSE
                  index <= inc_index;
                  push_or_pop <= '0';
               END IF;
            END IF;
         ELSE
            IF (push_or_pop = '1') THEN
               IF (en_filo_out = '1') THEN
                  CASE index_bit IS
                     WHEN '1' =>
                              filo_out_vhcg1 <= regbyte;
                     WHEN OTHERS  =>
                              filo_out_vhcg1 <= '0';

                  END CASE;
                  index_bit <= '1';
                  IF (index_bit = '1') THEN
                     IF (dec_index = "11111") THEN
                        index <= "00000";
                        push_or_pop <= '0';
                     ELSE
                        index <= dec_index;
                        push_or_pop <= '1';
                     END IF;
                  ELSE
                     index <= index;
                     push_or_pop <= push_or_pop;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

END translated;
