///////////////////////////////////////////////////////////////////
         //////                                    //////
///////////////////////////////////////////////////////////////////
///                                                             ///
/// This file is generated by Viterbi HDL Code Generator(VHCG)  ///
/// which is written by Mike Johnson at OpenCores.org  and      ///
/// distributed under GPL license.                              ///
///                                                             ///
/// If you have any advice,                                     ///
/// please email to jhonson.zhu@gmail.com                       ///
///                                                             ///
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////



`include "glb_def.v"

// the number of stages of one traceback output. It should be pow of two. The stage 
// is the stage of encode lattice of radix r.
`define OUT_STAGE_RADIX 5 
// 2^OUT_STAGE_RADIX 
`define OUT_STAGE       32

module filo
(
	clk, rst, 
	en_filo_in, filo_in, 
	en_filo_out, filo_out, 
	valid_out
);
input clk, rst, en_filo_in, en_filo_out;
input[`V-1:0] filo_in;
output filo_out;
output valid_out;

reg valid_out;
reg filo_out;
reg[`V-1:0] regfile[`OUT_STAGE-1:0];
reg[`OUT_STAGE_RADIX-1:0] index;
reg[`V-1:0] index_bit;		///////////////////////////////////////////////////////
reg push_or_pop;
wire[`V-1:0] regbyte;
wire[`OUT_STAGE_RADIX-1:0]  inc_index;
wire[`OUT_STAGE_RADIX-1:0]  dec_index;
integer i;

assign inc_index=index+1;
assign dec_index=index-1;
assign regbyte=regfile[index];
always @(posedge clk or posedge rst)
begin
    if(rst)
    begin
        for(i=0;i<`OUT_STAGE;i=i+1)
        begin
            regfile[i]<=0;
        end
        filo_out<=0;
        index<=0;
        index_bit<=`V'b1;							///////////////////////////////////////////////
        valid_out<=0;
        push_or_pop<=0;         //push
    end
    else
    begin
    	valid_out<=push_or_pop;
        // push data into the register file 
        if (push_or_pop == 0)
        begin
            if(en_filo_in)
            begin
                regfile[index]<=filo_in;
                if(inc_index==`OUT_STAGE_RADIX'b00000)		//////////////////////////////////////////////
                begin
                    index<=`OUT_STAGE_RADIX'b11111;		//////////////////////////////////////////////
                    push_or_pop<=1;
                end
                else
                begin
                    index<=inc_index;
                    push_or_pop<=0;
                end
            end
        end
        else 		//pop data from the register file 
        if (push_or_pop == 1)
        begin 
            if(en_filo_out)
            begin
                case(index_bit)
		///////////////////////////////////////////////
		`V'd1: filo_out<=regbyte[0];
	
                //    `V'b001:file_out<=regbyte[0];
                //  `V'd010: file_out<=regbyte[1];
                //  `V'd100: file_out<=regbyte[2];
                    default:filo_out<=0;
                endcase
		index_bit<=`V'b1;	
                if(index_bit==`V'b1)			/////////////////////////////////////////////////////
                begin
                    if(dec_index==`OUT_STAGE_RADIX'b11111)
                    begin
                        index<=0;
                        push_or_pop<=0;
                    end
                    else
                    begin
                        index<=dec_index;
                        push_or_pop<=1;
                    end
                end
                else
                begin
                    index<=index;
                    push_or_pop<=push_or_pop;
                end
            end
        end
    end    
end
endmodule
