
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--This is a head
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

--/////////////////////////////////////////////////////////////////
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;

ENTITY acs2 IS
   GENERIC (
      --branchs.
      --branch_M0 is the metric of cross branchs, branch_M1 is the parallel
      SM_Width                       :  integer := 8;
      BM_Width                       :  integer := 4);
   PORT (
      old_sm0                 : IN std_logic_vector(SM_Width - 1 DOWNTO 0);
      old_sm1                 : IN std_logic_vector(SM_Width - 1 DOWNTO 0);
      bm00                    : IN std_logic_vector(BM_Width - 1 DOWNTO 0);
      bm01                    : IN std_logic_vector(BM_Width - 1 DOWNTO 0);
      bm10                    : IN std_logic_vector(BM_Width - 1 DOWNTO 0);
      bm11                    : IN std_logic_vector(BM_Width - 1 DOWNTO 0);
      new_0sm                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
      new_1sm                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
      dec0                    : OUT std_logic;
      dec1                    : OUT std_logic);
END acs2;

ARCHITECTURE translated OF acs2 IS


   SIGNAL sum00                    :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL sum01                    :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL sum10                    :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL sum11                    :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL result0                  :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL result1                  :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL new_0sm_vhcg1            :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL new_1sm_vhcg2            :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL dec0_vhcg3               :  std_logic;
   SIGNAL dec1_vhcg4               :  std_logic;

BEGIN
   new_0sm <= new_0sm_vhcg1;
   new_1sm <= new_1sm_vhcg2;
   dec0 <= dec0_vhcg3;
   dec1 <= dec1_vhcg4;

   PROCESS (old_sm0, old_sm1, bm00, bm01, bm10, bm11)
      VARIABLE sum00_vhcg5  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE sum10_vhcg6  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE sum01_vhcg7  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE sum11_vhcg8  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE result0_vhcg9  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE result1_vhcg10  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE new_0sm_vhcg1_vhcg11  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE dec0_vhcg3_vhcg12  : std_logic;
      VARIABLE new_1sm_vhcg2_vhcg13  : std_logic_vector(SM_Width - 1 DOWNTO 0);
      VARIABLE dec1_vhcg4_vhcg14  : std_logic;
   BEGIN
      sum00_vhcg5 := old_sm0 + bm00;
      sum10_vhcg6 := old_sm1 + bm10;
      sum01_vhcg7 := old_sm0 + bm01;
      sum11_vhcg8 := old_sm1 + bm11;
      result0_vhcg9 := sum00_vhcg5 - sum10_vhcg6;
      result1_vhcg10 := sum01_vhcg7 - sum11_vhcg8;
      IF (result0_vhcg9(SM_Width - 1) = '1') THEN
         new_0sm_vhcg1_vhcg11 := sum00_vhcg5;
         dec0_vhcg3_vhcg12 := '0';
      ELSE
         new_0sm_vhcg1_vhcg11 := sum10_vhcg6;
         dec0_vhcg3_vhcg12 := '1';
      END IF;
      IF (result1_vhcg10(SM_Width - 1) = '1') THEN
         new_1sm_vhcg2_vhcg13 := sum01_vhcg7;
         dec1_vhcg4_vhcg14 := '0';
      ELSE
         new_1sm_vhcg2_vhcg13 := sum11_vhcg8;
         dec1_vhcg4_vhcg14 := '1';
      END IF;
      sum00 <= sum00_vhcg5;
      sum10 <= sum10_vhcg6;
      sum01 <= sum01_vhcg7;
      sum11 <= sum11_vhcg8;
      result0 <= result0_vhcg9;
      result1 <= result1_vhcg10;
      new_0sm_vhcg1 <= new_0sm_vhcg1_vhcg11;
      dec0_vhcg3 <= dec0_vhcg3_vhcg12;
      new_1sm_vhcg2 <= new_1sm_vhcg2_vhcg13;
      dec1_vhcg4 <= dec1_vhcg4_vhcg14;
   END PROCESS;

END translated;
