
-- Thanks for XHDL
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////
--This is a head
--/////////////////////////////////////////////////////////////////
--////                                    //////
--/////////////////////////////////////////////////////////////////
--/                                                             ///
--/ This file is generated by Viterbi HDL Code Generator(VHCG)  ///
--/ which is written by Mike Johnson at OpenCores.org  and      ///
--/ distributed under GPL license.                              ///
--/                                                             ///
--/ If you have any advice,                                     ///
--/ please email to jhonson.zhu@gmail.com                       ///
--/                                                             ///
--/////////////////////////////////////////////////////////////////
--/////////////////////////////////////////////////////////////////

--/////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_unsigned.all;

ENTITY butfly2 IS
   GENERIC (
      SM_Width                       :  integer := 8;
      BM_Width                       :  integer := 4;
      Bit_Width                      :  integer := 3);
   PORT (
      old_sm0                 : IN std_logic_vector(SM_Width - 1 DOWNTO 0);
      old_sm1                 : IN std_logic_vector(SM_Width - 1 DOWNTO 0);
      state_cluster           : IN std_logic_vector(6 - 2 DOWNTO 0);
      symbol0                 : IN std_logic_vector(Bit_Width - 1 DOWNTO 0);
      symbol1                 : IN std_logic_vector(Bit_Width - 1 DOWNTO 0);
      pattern                 : IN std_logic_vector(2 - 1 DOWNTO 0);
      new_sm0                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
      new_sm1                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
      dec0                    : OUT std_logic;
      dec1                    : OUT std_logic);
END butfly2;

ARCHITECTURE translated OF butfly2 IS

   COMPONENT acs2
      GENERIC (
          SM_Width                       :  integer := 8;
          BM_Width                       :  integer := 4);
         --branchs.
      PORT (
         old_sm0                 : IN  std_logic_vector(SM_Width - 1 DOWNTO 0);
         old_sm1                 : IN  std_logic_vector(SM_Width - 1 DOWNTO 0);
         bm00                    : IN  std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm01                    : IN  std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm10                    : IN  std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm11                    : IN  std_logic_vector(BM_Width - 1 DOWNTO 0);
         new_0sm                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
         new_1sm                 : OUT std_logic_vector(SM_Width - 1 DOWNTO 0);
         dec0                    : OUT std_logic;
         dec1                    : OUT std_logic);
   END COMPONENT;

   COMPONENT brameter2
      GENERIC (
          Bit_Width                      :  integer := 3;
          BM_Width                       :  integer := 4);
      PORT (
         state_cluster           : IN  std_logic_vector(4 DOWNTO 0);
         symbol0                 : IN  std_logic_vector(Bit_Width - 1 DOWNTO 0);
         symbol1                 : IN  std_logic_vector(Bit_Width - 1 DOWNTO 0);
         pattern                 : IN  std_logic_vector(2 - 1 DOWNTO 0);
         bm00                    : OUT std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm01                    : OUT std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm10                    : OUT std_logic_vector(BM_Width - 1 DOWNTO 0);
         bm11                    : OUT std_logic_vector(BM_Width - 1 DOWNTO 0));
   END COMPONENT;


   SIGNAL wire_bm00                :  std_logic_vector(BM_Width - 1 DOWNTO 0);
   SIGNAL wire_bm01                :  std_logic_vector(BM_Width - 1 DOWNTO 0);
   SIGNAL wire_bm10                :  std_logic_vector(BM_Width - 1 DOWNTO 0);
   SIGNAL wire_bm11                :  std_logic_vector(BM_Width - 1 DOWNTO 0);
   SIGNAL new_sm0_vhcg1            :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL new_sm1_vhcg2            :  std_logic_vector(SM_Width - 1 DOWNTO 0);
   SIGNAL dec0_vhcg3               :  std_logic;
   SIGNAL dec1_vhcg4               :  std_logic;

BEGIN
   new_sm0 <= new_sm0_vhcg1;
   new_sm1 <= new_sm1_vhcg2;
   dec0 <= dec0_vhcg3;
   dec1 <= dec1_vhcg4;
   unit_acs2 : acs2
      PORT MAP (
         old_sm0 => old_sm0,
         old_sm1 => old_sm1,
         bm00 => wire_bm00,
         bm01 => wire_bm01,
         bm10 => wire_bm10,
         bm11 => wire_bm11,
         new_0sm => new_sm0_vhcg1,
         new_1sm => new_sm1_vhcg2,
         dec0 => dec0_vhcg3,
         dec1 => dec1_vhcg4);

   unit_brameter2 : brameter2
      PORT MAP (
         state_cluster => state_cluster,
         symbol0 => symbol0,
         symbol1 => symbol1,
         pattern => pattern,
         bm00 => wire_bm00,
         bm01 => wire_bm01,
         bm10 => wire_bm10,
         bm11 => wire_bm11);


END translated;
