-- Technology and synthesis options
  constant CFG_FABTECH 	: integer := CONFIG_SYN_TECH;
  constant CFG_MEMTECH  : integer := CFG_RAM_TECH;
  constant CFG_PADTECH 	: integer := CFG_PAD_TECH;
  constant CFG_NOASYNC 	: integer := CONFIG_SYN_NO_ASYNC;
  constant CFG_SCAN 	: integer := CONFIG_SYN_SCAN;

-- Clock generator
  constant CFG_CLKTECH 	: integer := CFG_CLK_TECH;
  constant CFG_CLKMUL   : integer := CONFIG_CLK_MUL;
  constant CFG_CLKDIV   : integer := CONFIG_CLK_DIV;
  constant CFG_OCLKDIV  : integer := CONFIG_OCLK_DIV;
  constant CFG_PCIDLL   : integer := CONFIG_PCI_CLKDLL;
  constant CFG_PCISYSCLK: integer := CONFIG_PCI_SYSCLK;
  constant CFG_CLK_NOFB : integer := CONFIG_CLK_NOFB;

-- AMBA settings
  constant CFG_DEFMST  	  : integer := CONFIG_AHB_DEFMST;
  constant CFG_RROBIN  	  : integer := CONFIG_AHB_RROBIN;
  constant CFG_SPLIT   	  : integer := CONFIG_AHB_SPLIT;
  constant CFG_AHBIO   	  : integer := 16#CONFIG_AHB_IOADDR#;
  constant CFG_APBADDR 	  : integer := 16#CONFIG_APB_HADDR#;
  constant CFG_AHB_MON 	  : integer := CONFIG_AHB_MON;
  constant CFG_AHB_MONERR : integer := CONFIG_AHB_MONERR;
  constant CFG_AHB_MONWAR : integer := CONFIG_AHB_MONWAR;

-- DSU UART
  constant CFG_AHB_UART	: integer := CONFIG_DSU_UART;

-- JTAG based DSU interface
  constant CFG_AHB_JTAG	: integer := CONFIG_DSU_JTAG;

-- Ethernet DSU
  constant CFG_DSU_ETH	: integer := CONFIG_DSU_ETH + CONFIG_DSU_ETH_PROG;
  constant CFG_ETH_BUF 	: integer := CFG_DSU_ETHB;
  constant CFG_ETH_IPM 	: integer := 16#CONFIG_DSU_IPMSB#;
  constant CFG_ETH_IPL 	: integer := 16#CONFIG_DSU_IPLSB#;
  constant CFG_ETH_ENM 	: integer := 16#CONFIG_DSU_ETHMSB#;
  constant CFG_ETH_ENL 	: integer := 16#CONFIG_DSU_ETHLSB#;

-- PROM/SRAM controller
  constant CFG_SRCTRL           : integer := CONFIG_SRCTRL;
  constant CFG_SRCTRL_PROMWS    : integer := CONFIG_SRCTRL_PROMWS;
  constant CFG_SRCTRL_RAMWS     : integer := CONFIG_SRCTRL_RAMWS;
  constant CFG_SRCTRL_IOWS      : integer := CONFIG_SRCTRL_IOWS;
  constant CFG_SRCTRL_RMW       : integer := CONFIG_SRCTRL_RMW;
  constant CFG_SRCTRL_8BIT      : integer := CONFIG_SRCTRL_8BIT;

  constant CFG_SRCTRL_SRBANKS   : integer := CFG_SR_CTRL_SRBANKS;
  constant CFG_SRCTRL_BANKSZ    : integer := CFG_SR_CTRL_BANKSZ;
  constant CFG_SRCTRL_ROMASEL   : integer := CONFIG_SRCTRL_ROMASEL;
-- LEON2 memory controller
  constant CFG_MCTRL_LEON2    : integer := CONFIG_MCTRL_LEON2;
  constant CFG_MCTRL_RAM8BIT  : integer := CONFIG_MCTRL_8BIT;
  constant CFG_MCTRL_RAM16BIT : integer := CONFIG_MCTRL_16BIT;
  constant CFG_MCTRL_5CS      : integer := CONFIG_MCTRL_5CS;
  constant CFG_MCTRL_SDEN     : integer := CONFIG_MCTRL_SDRAM;
  constant CFG_MCTRL_SEPBUS   : integer := CONFIG_MCTRL_SDRAM_SEPBUS;
  constant CFG_MCTRL_INVCLK   : integer := CONFIG_MCTRL_SDRAM_INVCLK;
  constant CFG_MCTRL_SD64     : integer := CONFIG_MCTRL_SDRAM_BUS64;
  constant CFG_MCTRL_PAGE     : integer := CONFIG_MCTRL_PAGE + CONFIG_MCTRL_PROGPAGE;

-- SDRAM controller
  constant CFG_SDCTRL  	: integer := CONFIG_SDCTRL;
  constant CFG_SDCTRL_INVCLK  	: integer := CONFIG_SDCTRL_INVCLK;
  constant CFG_SDCTRL_SD64    	: integer := CONFIG_SDCTRL_BUS64;
  constant CFG_SDCTRL_PAGE    	: integer := CONFIG_SDCTRL_PAGE + CONFIG_SDCTRL_PROGPAGE;

-- AHB ROM
  constant CFG_AHBROMEN	: integer := CONFIG_AHBROM_ENABLE;
  constant CFG_AHBROPIP	: integer := CONFIG_AHBROM_PIPE;
  constant CFG_AHBRODDR	: integer := 16#CONFIG_AHBROM_START#;
  constant CFG_ROMADDR	: integer := 16#CONFIG_ROM_START#;
  constant CFG_ROMMASK	: integer := 16#E00# + 16#CONFIG_ROM_START#;

-- AHB RAM
  constant CFG_AHBRAMEN	: integer := CONFIG_AHBRAM_ENABLE;
  constant CFG_AHBRSZ	: integer := CFG_AHBRAMSZ;
  constant CFG_AHBRADDR	: integer := 16#CONFIG_AHBRAM_START#;

-- Gaisler Ethernet core
  constant CFG_GRETH   	: integer := CONFIG_GRETH_ENABLE;
  constant CFG_GRETH1G	: integer := CONFIG_GRETH_GIGA;
  constant CFG_ETH_FIFO : integer := CFG_GRETH_FIFO;

-- PCI interface
  constant CFG_PCI     	: integer := CFG_PCITYPE;
  constant CFG_PCIVID   : integer := 16#CONFIG_PCI_VENDORID#;
  constant CFG_PCIDID   : integer := 16#CONFIG_PCI_DEVICEID#;
  constant CFG_PCIDEPTH : integer := CFG_PCIFIFO;
  constant CFG_PCI_MTF  : integer := CFG_PCI_ENFIFO;

-- PCI arbiter
  constant CFG_PCI_ARB  : integer := CONFIG_PCI_ARBITER;
  constant CFG_PCI_ARBAPB : integer := CONFIG_PCI_ARBITER_APB;
  constant CFG_PCI_ARB_NGNT : integer := CONFIG_PCI_ARBITER_NREQ;

-- PCI trace buffer
  constant CFG_PCITBUFEN: integer := CONFIG_PCI_TRACE;
  constant CFG_PCITBUF  : integer := CFG_PCI_TRACEBUF;

-- UART 1
  constant CFG_UART1_ENABLE : integer := CONFIG_UART1_ENABLE;
  constant CFG_UART1_FIFO   : integer := CFG_UA1_FIFO;

-- UART 2
  constant CFG_UART2_ENABLE : integer := CONFIG_UART2_ENABLE;
  constant CFG_UART2_FIFO   : integer := CFG_UA2_FIFO;

-- Modular timer
  constant CFG_GPT_ENABLE   : integer := CONFIG_GPT_ENABLE;
  constant CFG_GPT_NTIM     : integer := CONFIG_GPT_NTIM;
  constant CFG_GPT_SW       : integer := CONFIG_GPT_SW;
  constant CFG_GPT_TW       : integer := CONFIG_GPT_TW;
  constant CFG_GPT_IRQ      : integer := CONFIG_GPT_IRQ;
  constant CFG_GPT_SEPIRQ   : integer := CONFIG_GPT_SEPIRQ;
  constant CFG_GPT_WDOGEN   : integer := CONFIG_GPT_WDOGEN;
  constant CFG_GPT_WDOG     : integer := 16#CONFIG_GPT_WDOG#;

-- GPIO port
  constant CFG_GRGPIO_ENABLE : integer := CONFIG_GRGPIO_ENABLE;
  constant CFG_GRGPIO_IMASK  : integer := 16#CONFIG_GRGPIO_IMASK#;
  constant CFG_GRGPIO_WIDTH  : integer := CONFIG_GRGPIO_WIDTH;

-- GRLIB debugging
  constant CFG_DUART    : integer := CONFIG_DEBUG_UART;

