
/* Template boot-code for LEON3 test benches */

#ifndef STACKSIZE
#define STACKSIZE 0x00002000
#endif

#include "prom.h"

	.seg	"text"
	.proc	0
	.align	4
	.global start
	.global _start
start:
_start:
	nop
	nop
	nop
	nop

	nop
	nop
	nop
	nop
9:	

	wrpr	%g0, 0, %tick

	mov	%g0, %o0
	wrpr	%g0, 1, %tl
	wrpr	%g0, 7, %cleanwin
	wrpr	%g0, 0, %otherwin
	wrpr	%g0, 0, %wstate
	wrpr	%g0, 0, %cwp
	wrpr	%g0, 0, %canrestore
	wrpr	%g0, 5, %cansave
	wrpr	%g0, 4, %pstate
	wrpr	%g0, 1, %gl
	nop; nop; nop; nop; nop; nop

	flush

	set  1, %g0
	set  1, %g1
	set  1, %g2

	set	0x4082e4, %g1
	jmp	%g1
	nop
	ba 7f
	nop
	flush

	set 0x10e0, %g1		! init IU
	mov %g1, %psr
	mov %g0, %wim
	mov %g0, %tbr
	mov %g0, %y
	mov %g0, %asr16
	nop
	set  0x81000f, %g1
	sta %g1, [%g0] 2
	mov %g0, %g2
	nop
	nop
	nop
	nop
	nop
	or %g2, %g2, %g0
	nop
	nop
	nop
	nop
	nop
2:
	mov %asr17, %g3
	and %g3, 0x1f, %g3
	mov %g0, %g4
	mov %g0, %g5
	mov %g0, %g6
	mov %g0, %g7
1:
	mov %g0, %l0
	mov %g0, %l1
	mov %g0, %l2
	mov %g0, %l3
	mov %g0, %l4
	mov %g0, %l5
	mov %g0, %l6
	mov %g0, %l7
	mov %g0, %o0
	mov %g0, %o1
	mov %g0, %o2
	mov %g0, %o3
	mov %g0, %o4
	mov %g0, %o5
	mov %g0, %o6
	mov %g0, %o7
	subcc %g3, 1, %g3
	bge 1b
	save

	mov	2, %g1
	mov	%g1, %wim
	set 0x10e0, %g1		! enable traps
	mov %g1, %psr
	nop; nop; nop;

	mov %psr, %g1
	srl %g1, 12, %g1
	andcc %g1, 1, %g0
	be 1f
	nop

	set _fsrxx, %g3
	ld [%g3], %fsr
	ldd [%g3], %f0
	ldd [%g3], %f2
	ldd [%g3], %f4
	ldd [%g3], %f6
	ldd [%g3], %f8
	ldd [%g3], %f10
	ldd [%g3], %f12
	ldd [%g3], %f14
	ldd [%g3], %f16
	ldd [%g3], %f18
	ldd [%g3], %f20
	ldd [%g3], %f22
	ldd [%g3], %f24
	ldd [%g3], %f26
	ldd [%g3], %f28
	ldd [%g3], %f30
	nop
	nop
	nop
	nop
	nop
	faddd %f0, %f2, %f4
	nop
	nop
	nop
	nop
	ba  1f	
	nop
	
	
.align	8
_fsrxx:
	.word 0
	.word 0

1:
	mov %asr17, %g3
	srl %g3, 28, %g3
	andcc %g3, 0x0f, %g3
	bne 1f

6:
clear_l1_tag:
	mov	0x3, %g1
	sllx	%g1, 16, %g1
	mov	0x1, %g3
	sllx	%g3, 16, %g3
icache_init_loop1:
	mov	0x7f, %g2
	sllx	%g2, 6, %g2
icache_init_loop2:
	stxa	%g0, [%g1+%g2] 0x67	! ASI_ICACHE_TAG
	brnz	%g2, icache_init_loop2
	sub	%g2, 0x40, %g2
	brnz	%g1, icache_init_loop1
	sub	%g1, %g3, %g1
	mov	0x1ff, %g1
	sllx	%g1, 4, %g1
dcache_init_loop:
	stxa	%g0, [%g0+%g1] 0x47	! ASI_DCACHE_TAG
	brnz	%g1, dcache_init_loop
	sub	%g1, 0x10, %g1
7:
	set L2MCTRLIO, %g1
	signx %g1, %g1
!	ba  7b
	set MCFG1, %g2
	st  %g2, [%g1]
	set MCFG2, %g2
	st  %g2, [%g1+4]
	set MCFG3, %g2
	st  %g2, [%g1+8]
!	set IRQCTRL, %g1
!	set 0x0ffff, %g2
!	st  %g2, [%g1+0x10]

	set 0x8000F860, %g1
	signx %g1, %g1
	ld  [%g1], %g2
	srl %g2, 12, %g2
	set 0x01009, %g1
	subcc %g1, %g2, %g0
	bne 1f

	set ASDCFG, %g1
	signx %g1, %g1
	set DSDCFG, %g2
	st  %g2, [%g1]

	! %g3 = cpu index
1:	set STACKSIZE, %g2

3:	set RAMSTART+ RAMSIZE-32, %fp
	sub %fp, %g1, %fp
	sub %fp, 96, %sp

	set RAMSTART, %g1

	jmp %g1
	nop

.align	32
