--GAISLER_LICENSE
-----------------------------------------------------------------------------
-- Entity: 	t1
-- File:	t1.vhd
-- Author:	Jiri Gaisler - Gaisler Research
-- Description:	Types and component declations for Sun T1
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
library grlib;
use grlib.amba.all;
library gaisler;
use gaisler.uart.all;

package t1 is

  type t1_in_type is record
    reset_l		 : std_ulogic;
    pcx_spc_grant_px 	 : std_logic_vector(4 downto 0);
    cpx_spc_data_rdy_cx2 : std_ulogic;
    cpx_spc_data_cx2 	 : std_logic_vector(144 downto 0);
  end record;

  type t1_out_type is record
    spc_pcx_req_pq   : std_logic_vector(4 downto 0);
    spc_pcx_atom_pq  : std_ulogic;
    spc_pcx_data_pa  : std_logic_vector(123 downto 0);
    rst_ready        : std_ulogic;
  end record;

  component t1core
  port (
    clk    	: in  std_ulogic;
    t1in	: in  t1_in_type;
    t1out	: out t1_out_type
  );
  end component;

  component iop_fpga
  port (
    reset_l 	     : in  std_ulogic;
    gclk    	     : in  std_ulogic;
    spc_pcx_req_pq   : out std_logic_vector(4 downto 0);
    spc_pcx_atom_pq  : out std_ulogic;
    spc_pcx_data_pa  : out std_logic_vector(123 downto 0);
    pcx_spc_grant_px : in  std_logic_vector(4 downto 0);
    cpx_spc_data_rdy_cx2 : in std_ulogic;
    cpx_spc_data_cx2 : in  std_logic_vector(144 downto 0);
    rst_ready        : out std_ulogic
  );
  end component;

  component pcxahb
   generic (
     hindex : integer := 0;
     pindex : integer := 0;
     paddr  : integer := 0;
     pmask  : integer := 16#fff#;
     pirq   : integer := 0;
     pow    : integer := 1	-- start on power-on
	);
   port (
      rst  : in  std_logic;
      clk  : in  std_ulogic;
      t1in : out t1_in_type;
      t1out: in  t1_out_type;
      apbi : in  apb_slv_in_type;
      apbo : out apb_slv_out_type;
      ahbi : in  ahb_mst_in_type;
      ahbo : out ahb_mst_out_type 
      );
  end component;

  component apb16550 is
  generic (
    pindex   : integer := 0;
    paddr    : integer := 0;
    pmask    : integer := 16#fff#;
    console  : integer := 0;
    pirq     : integer := 0;
    parity   : integer := 1;
    flow     : integer := 1;
    fifosize : integer range 1 to 32 := 1;
    abits    : integer := 8;
    brate    : integer := 8);
  port (
    rst    : in  std_ulogic;
    clk    : in  std_ulogic;
    apbi   : in  apb_slv_in_type;
    apbo   : out apb_slv_out_type;
    uarti  : in  uart_in_type;
    uarto  : out uart_out_type);
  end component;

end;
