--GAISLER_LICENSE
-----------------------------------------------------------------------------
-- Entity: 	t1core
-- File:	t1core.vhd
-- Author:	Jiri Gaisler - Gaisler Research
-- Description:	Wrapper for T1 iop_fpga core
------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
library grlib;
use grlib.amba.all;
use work.t1.all;

entity t1core is
  port (
    clk    	: in  std_ulogic;
    t1in	: in  t1_in_type;
    t1out	: out t1_out_type
  );
end;

architecture rtl of t1core is
begin

  t1_0 : iop_fpga port map (t1in.reset_l, clk, t1out.spc_pcx_req_pq, 
	t1out.spc_pcx_atom_pq, t1out.spc_pcx_data_pa, t1in.pcx_spc_grant_px,
	t1in.cpx_spc_data_rdy_cx2, t1in.cpx_spc_data_cx2, t1out.rst_ready);

end;
